% APRROXIMATION OF DATA BY MEANS OF FOURIER ROWS
clear all; close all; clc;

% INPUT OF PROFILE DATA - from 2 columns file (into matrix inpXdT)
[fname,pname] = uigetfile('*.dat','input of data');
inpXF = dlmread(fname,' ');
% columns are separated into vectors X and dT
X=inpXF(:,1);  F=inpXF(:,2);

% number of readed data-rows is determined - put into m
m = numel(X)
L = (X(m) - X(1))/2;
dx = X(2) - X(1);

% evaluation of Fourier coefficients A0, An and Bn
a0 = (1/L)*trapz(F)*dx; % utilization of the numerical integration method - trapezoid rule
for n=1:m-1
    for i=1:m-1
    hlpa(i) = F(i)*cos(n*pi*X(i)/L); 
    hlpb(i) = F(i)*sin(n*pi*X(i)/L);
    end;
    a(n) = (1/L)*trapz(hlpa)*dx; b(n) = (1/L)*trapz(hlpb)*dx;
end;

% here the user can define the upper sumation limit of Fourier coefficients
upper_sumation_limit = 120;

% evaluatiion of the Fourier series approximation
for j=1:m sum = a0/2; double(sum);
    for n=1:upper_sumation_limit
    sum = sum + a(n)*cos(n*pi*X(j)/L) + b(n)*sin(n*pi*X(j)/L);
    end;
    apprF(j) = sum;
end;

% plotting the result
figure, plot(X,F,X,apprF); xlabel('x [m]','FontSize',10); ylabel('field []','FontSize',10);
pomocstr = num2str(upper_sumation_limit); % converts number to string
legend('original data', pomocstr);

% END OF THE SCRIPT